/*
	Puppet:

	This object represents the puppet on the stage.
*/

define(["src/utils", "lodash", "lib/dev/internal"],
function (utils, lodash, devInternal) {
	"use strict";

	var now = nmlImpl.getCurrentTime,
		min = Math.min,
		max = Math.max;

	var zones, stack, reportBegin;
	function reset () {
		zones = {};
		stack = [];
		reportBegin = false;
	}
	reset();

	function push (name) {
		var zone = zones[name] || {
			name : name,
			total : 0.0,
			avg : 0.0,
			min : Infinity,
			max : 0.0,
			calls : 0,
			begin : []
		};
		zones[name] = zone;
		stack.push(name);
		zone.calls += 1;
		zone.begin.push(now());
	}

	function pop () {
		var name = stack.pop();
		utils.assert(name);
		var zone = zones[name],
			dt = now() - zone.begin.pop();

		zone.total += dt;
		zone.avg = zone.total / zone.calls;
		zone.min = min(zone.min, dt);
		zone.max = max(zone.max, dt);
	}

	return devInternal.ifEnabled({enabled : false}, {  // note to self, here's the magic line
		push : push,
		pop : pop,

		report : function (period) {
			var t = now();

			if ( reportBegin ) {
				if (t - reportBegin > period) {
					lodash.forOwn(zones, function (zone, name) {
						console.logToUser("name: " + name + ",\tcalls: " + zone.calls + ",\ttotal: " + zone.total + "s,\tavg: " + zone.avg*1000 + "ms,\tmax: " + zone.max*1000 + "ms,\tmin: " + zone.min*1000 + "ms");
						lodash.assign(zone, {
							total : 0.0,
							avg : 0.0,
							min : Infinity,
							max : 0.0,
							calls : 0
						});
					});
					reportBegin = t;
				}
			} else {
				reportBegin = t;
			}
		},

		wrap : function (name, fn) {
			return function () {
				push(name);
				var result = fn.apply(this, arguments);
				pop();
				return result;
			};
		},

		reset : reset
	});
});
